package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.w3c.dom.Node;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.junit.Assert.assertTrue;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "get_letters_by_message_id",
        apicommand = "get_letters_by_message_id",
        description = "Получение мулечного id по messageId"

)
public class GetLettersByMessageId extends Oper<GetLettersByMessageId> {


    /**
     * Получает значение тега, содержащего mid
     * Если такого тега нет, фейлит тест
     *
     * @return - значение тега mailbox_mid
     */
    public String getMid() {
        Node necessaryTag = toDocument().getElementsByTagName("mailbox_mid").item(0);
        // Есть ли вообще такой тег в выдаче
        assertTrue("<mailbox_mid> tag not found", necessaryTag != null);
        String midNew = necessaryTag.getTextContent();

        // Логирование
        logger.info("MID: " + midNew);

        return midNew;
    }

}
