package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.w3c.dom.NodeList;
import ru.yandex.autotests.innerpochta.beans.labels.LabelSymbol;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * <p> Created by IntelliJ IDEA.
 * <p> User: lanwen
 * <p> Date: 22.03.12
 * <p> Time: 17:02
 */
@OperClass(
        /**
         * Нужно заметить, что апи ручка видоизменяется специальным образом так, что имя становится взятым
         * из спец-файла с локалями.
         * Таким же образом, из ее выдачи удаляются все стандартные скрытые метки
         */
        apicommand = "labels",
        jsxcommand = "label_list",
        description = "Вывод списка меток"
)
public class Labels extends Oper<Labels> {

    private Labels() {
    }

    public static Labels labels() {
        return api(Labels.class);
    }

    /**
     * Получение lid метки по ее имени
     *
     * @param name - имя метки
     *
     * @return String lid этой метки
     */
    public String lidByName(String name) {

        String label = documentConverter.byXpath("//label[name='" + name + "']/lid/text()").asString();

        // Логирование
        logger.info("Lid: " + label + " with name - " + name);

        return label;
    }

    private String lidBySymbol(String name) {
        String label = documentConverter.byXpath("//label[symbol='" + name + "']/lid/text()").asString();

        // Логирование
        logger.info("Lid: " + label + " with name - " + name);

        return label;
    }

    public String lidBySymbol(LabelSymbol name) {
        return lidBySymbol(name.toString());
    }

    /**
     * Получение списка всех меток, за исключением системных
     *
     * @return List<String> - список меток, исключая некоторые системные
     */
    public List<String> getAllLabelIdsExeptSomeSystem() {
        return documentConverter.byXpath("//label" +
                "[not(name/text()='delivery_confirmation') " +
                "and not(name/text()='Важные') " +
                "and not(name/text()='priority_high') " +
                "and not(name/text()='remindme_threadabout:mark') " +
                "and not(name/text()='deleted') " +
                "and not(name/text()='_pinned_') " +
                "and not(name/text()='remindme_aviaeticket') " +
                "and not(contains(lid/text(),'FAKE'))]" +
                "/lid/text()").asList();
    }


    /**
     * Получение списка всех меток, за исключением системных
     *
     * @return List<String> - список меток, исключая некоторые системные
     */
    public List<String> getAllUserLabelIds() {
        return documentConverter.byXpath("//label[type/text()='1']/lid/text()").asList();
    }

    /**
     * Получение списка всех имен меток
     *
     * @return List<String> - список имен меток
     */
    public List<String> getAllLabelNames() {
        return documentConverter.byXpath("//label/name/text()").asList();
    }

    /**
     * Проверка наличия метки с заданным lid
     *
     * @param lid - ид метки для проверки
     *
     * @return true если такая метка есть
     */
    public Boolean isThereLabelWithSuchId(String lid) {
        NodeList nodes = documentConverter.byXpath("//label[lid='" + lid + "']").asNodeList();
        return (nodes.item(0) != null);
    }

    /**
     * Проверка наличия метки с заданным именем
     *
     * @param name - имя метки для проверки
     *
     * @return true если такая метка есть
     */
    public Boolean isThereLabelWithSuchName(String name) {
        NodeList nodes = documentConverter.byXpath("//label[name='" + name + "']").asNodeList();
        return (nodes.item(0) != null);
    }

    /**
     * Проверяем наличие всех меток из списка
     * Не делал ассертами, т.к. метод нужен для начальных установок и создания отсутствующих меток
     * Проверяет до первой отсутствующей
     *
     * @param labelNames - список строк-имен меток
     *
     * @return Boolean true, если все метки на месте, false, даже если не хватает одной
     */
    public Boolean isThereAllLabelsFromList(List<String> labelNames) {
        for (String name : labelNames) {
            if (!isThereLabelWithSuchName(name)) {
                logger.error("Метки " + name + " не обнаружено");
                return false;
            }
        }
        return true;
    }

    /**
     * Проверка наличия метки с заданным цветом и именем
     *
     * @param name  - имя метки
     * @param color - цвет метки
     *
     * @return true если есть такая метка
     */
    public Boolean isThereLabel(String name, String color) {
        NodeList nodes = documentConverter.byXpath("//label[name='"
                + name + "' and color='" + color + "']").asNodeList();
        return (nodes.item(0) != null);
    }

    public Integer getLabelCount(String name) {
        return documentConverter.byXpath("//label[name='" + name + "']/count/text()").asInteger();
    }

    public String nameBySymbol(LabelSymbol labelSymbol) {
        String name = documentConverter.byXpath("//label[symbol='" + labelSymbol + "']/name/text()").asString();
        return name;
    }
}
