package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailSendMsgObj;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import static com.jayway.restassured.path.xml.XmlPath.from;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * ru.yandex.autotests.innerpochta.wmi.core.wmiobjstruct
 */
@OperClass(
        jsxcommand = "mail_send",
        apicommand = "mail_send",
        description = "Отправка письма"
)
public class MailSend extends Oper<MailSend> {


    /**
     * Достаем значение mid сохраненного в исходящих письма из ответа операции отправки
     * В случае если используем не sjsx ручку, выдаем предупреждение в лог в виде ошибки
     *
     * @return String значение тега storedmid
     */
    public String getStoremidValue() {
        try {
            String storemid = Util.getSingleNodeValue(toDocument(), "storedmid");

            // Логирование
            logger.info("Storemid: " + storemid);

            return storemid;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getMessageId() throws Exception {
        return Util.getSingleNodeValue(toDocument(), "message_id");
    }

    /**
     * Достаем значение mid сохраненного в черновики письма
     *
     * @return String значение тега ids
     */
    public String getIdsValue() {
        return documentConverter.log(logger, "IDS").byXpath("//ids/text()").asString();
    }

    /**
     * Достаем значение mid сохраненного в черновики письма
     *
     * @return String значение тега ids
     */
    public String getMarkAsValue() {
        try {
            String markAs = Util.getSingleNodeValue(toDocument(), "mark_as");
            // Логирование
            logger.info("MARK_AS: " + markAs);
            return markAs;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public MailSend markAs(Matcher<String> matcher) {
        assertThat("Значение mark_as неверное", getMarkAsValue(), matcher);
        return this;
    }


    /**
     * Возвращает значение тега result в выдаче.
     * В случае отправки спама может быть равен:
     * virus_found
     * captcha_request
     * <p/>
     * Обычно не должен быть пустым и должен быть равен:
     * ok
     *
     * @return String - значение тега результата
     * @throws Exception
     */
    public String getResultValue() throws Exception {
        assertThat("В ответе присутствует больше одного <result>",
                documentConverter.byXpath("//result").asNodeList().getLength(), Matchers.equalTo(1));
        return Util.getSingleNodeValue(toDocument(), "result");
    }


    /**
     * Возвращает значение тега status в выдаче.
     * <p/>
     * Обычно не должен быть пустым и должен быть равен:
     * ok
     *
     * @return String - значение тега результата
     * @throws Exception
     */
    public String getStatusValue() throws Exception {
        assertThat("В ответе присутствует больше одного <status>",
                documentConverter.byXpath("//status").asNodeList().getLength(), Matchers.equalTo(1));
        return Util.getSingleNodeValue(toDocument(), "status");
    }

    public String getLimitedLogin() {
        return from(respAsString).getString("*.limited.recipient.@login");
    }

    /**
     * Для jsx
     * @return
     * @throws Exception
     */
    public MailSend statusOk() throws Exception {
        assertThat("Должен быть статус OK", getStatusValue(),
                equalTo("ok"));
        return this;
    }

    /**
     * Для jsx
     * @return
     * @throws Exception
     */
    public MailSend statusOk(String comment) throws Exception {
        assertThat("Должен быть статус OK, " + comment, getStatusValue(),
                equalTo("ok"));
        return this;
    }

    /**
     * Для api
     * @return
     * @throws Exception
     */
    public MailSend resultOk() throws Exception {
        assertThat("Должен быть результат OK", getResultValue(),
                equalTo("ok"));
        return this;
    }

    /**
     * Для api
     * @return
     * @throws Exception
     */
    public MailSend resultOk(String comment) throws Exception {
        assertThat("Должен быть результат OK, " + comment, getResultValue(),
                equalTo("ok"));
        return this;
    }

    public MailSend status(String status) throws Exception {
        assertThat("Должен быть статус " + status, getStatusValue(),
                equalTo(status));
        return this;
    }

    public MailSend shouldBeStrongSpam() throws Exception {
        assertThat("Ожидался результат strongspam_found", getStatusValue(), equalTo("strongspam_found"));
        return this;
    }

    public MailSend shouldBeLightSpam() throws Exception {
        assertThat("Ожидался результат captcha_request", getStatusValue(), equalTo("captcha_request"));
        return this;
    }

    /**
     * Фабрика для отправки письма через продакшн
     *
     * @param msg
     *
     * @return
     */
    public static MailSend sendViaProd(MailSendMsgObj msg) {
        return api(MailSend.class).setHost(props().productionHost()).params(msg);
    }

    /**
     * Возвращает значение тега captcha_key при отправке легкого спама
     * <p/>
     * Обычно что-то вроде: d2lIrzakHwGvrtY7Ru8I1KrI84GqlSBB
     *
     * @return String - значение тега результата
     * @throws Exception
     */
    public String getCaptchaKey() throws Exception {
        assertThat("В ответе присутствует больше одного <captcha_key>",
                documentConverter.byXpath("//captcha_key").asNodeList().getLength(), Matchers.equalTo(1));
        return Util.getSingleNodeValue(toDocument(), "captcha_key");
    }

    /**
     * Возвращает значение тега captcha_url при отправке легкого спама
     * <p/>
     * Обычно что-то вроде: http://s.captcha.yandex.net/image?key=d2lIrzakHwGvrtY7Ru8I1KrI84GqlSBB
     *
     * @return String - значение тега результата
     * @throws Exception
     */
    public String getCaptchaUrl() throws Exception {
        assertThat("В ответе присутствует больше одного <captcha_url>",
                documentConverter.byXpath("//captcha_url").asNodeList().getLength(), Matchers.equalTo(1));
        return Util.getSingleNodeValue(toDocument(), "captcha_url");
    }

}
