package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.w3c.dom.NodeList;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

import java.util.List;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "mailbox_list_nearest",
        description = "Получаем ближайшие письма"
)
public class MailboxListNearest extends Oper<MailboxListNearest> {

    public static MailboxListNearest mailboxListNearestJsx(Obj obj) {
       return jsx(MailboxListNearest.class).params(obj);
    }

    public Integer countMessagesInFolder() {
        NodeList nodes = documentConverter.byXpath("//message").asNodeList();
        return nodes.getLength();
    }

    public MailboxListNearest countShouldBe(Integer count) {
        assertThat("Неверное количество писем в выдаче mailbox_list_nearest",
                countMessagesInFolder(), equalTo(count));
        return this;
    }

    public List<String> getMids() {
        return documentConverter.byXpath("//message/@mid").asList();
    }
}
