package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailboxOperObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.MailboxOperObj.*;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * ru.yandex.autotests.innerpochta.wmi.core.wmiobjstruct
 */
@OperClass(
        apicommand = "mailbox_oper",
        jsxcommand = "mailbox_oper",
        description = "Операция над письмами"
)
public class MailboxOper extends Oper<MailboxOper> {

    public static MailboxOper mailboxOper(Obj params) {
        return jsx(MailboxOper.class).params(params);
    }

    public static MailboxOper move(String mid, String dstFid, String srcFid) {
        return mailboxOper(moveOneMsg(mid, dstFid, srcFid));
    }

    public static MailboxOper move(List<String> mids, String dstFid, String srcFid) {
        return mailboxOper(moveSomeMsges(mids, dstFid, srcFid));
    }

    public static MailboxOper moveTid(String tid, String dstFid, String srcFid) {
        return mailboxOper(moveSomeMsgesOnTid(tid, dstFid, srcFid));
    }

    public static MailboxOper markRead(List<String> mids) {
        return mailboxOper(markReadMsgs(mids));
    }

    public static MailboxOper markRead(String mid) {
        return mailboxOper(markReadMsgs(newArrayList(mid)));
    }

    public static MailboxOper markUnread(String mid) {
        return mailboxOper(markUNReadMsgs(newArrayList(mid)));
    }

    public static MailboxOper markUnread(List<String> mids) {
        return mailboxOper(markUNReadMsgs(mids));
    }

    public static MailboxOper markSpam(String mid) {
        return mailboxOper(MailboxOperObj.empty().addIds(mid).setOper(OPER_TOSPAM));
    }

    public static MailboxOper markNotSpam(String mid) {
        return mailboxOper(MailboxOperObj.empty().addIds(mid).setOper(OPER_NOSPAM));
    }

    public static MailboxOper operDelete(String mid) {
        return mailboxOper(MailboxOperObj.empty().addIds(mid).setOper(OPER_DELETE));
    }

    public static MailboxOper operDelete(List<String> mids) {
        return mailboxOper(MailboxOperObj.empty().setIds(mids).setOper(OPER_DELETE));
    }

    public MailboxOper yamail() {
        assertThat("Ответ должен содержать только <yamail />", respAsString,
                equalTo("<yamail />"));
        return this;
    }

    public MailboxOper resultIdOk() {
        assertThat("Ответ должен соержать <status result_id=\"ok\" reason=\"ok\"/>", respAsString,
                containsString("<status reason=\"ok\" result_id=\"ok\"></status>"));
        return this;
    }

    public MailboxOper reasonOk() {
        assertThat("Ответ должен соержать <status reason=\"ok\"></status>", respAsString,
                containsString("<status reason=\"ok\"></status>"));
        return this;
    }


}
