package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "message_body",
        description = "Вывод только тела письма"
)
public class MessageBody extends Oper<MessageBody> {

    public static Via messageBody(Obj params) {
        return jsx(MessageBody.class)
                .params(params)
                .post();
    }

    /**
     * Получаем timestamp
     *
     * @return String свойство timestamp
     */
    public Long getTimestamp() {
        return documentConverter.byXpath("//info/date/timestamp").as(Long.class);
    }

    /**
     * Получаем user_timestamp
     *
     * @return String свойство user_timestamp
     */
    public String getUserTimestamp() {
        return documentConverter.byXpath("//info/date/user_timestamp").asString();
    }

    /**
     * Получаем <message-id>
     * (это НЕ mid)
     *
     * @return String свойство message_id
     */
    public String getMessageId() {
        return documentConverter.byXpath("//info/message-id").asString();
    }

    /**
     * Получаем to/name
     * @return String свойство to/name
     */
    public String getToName() {
        return documentConverter.byXpath("//info/to/name").asString();
    }

    /**
     * Получаем to/email
     * @return String свойство to/name
     */
    public String getToEmail() {
        return documentConverter.byXpath("//info/to/email").asString();
    }

    /**
     * Возвращает значение тега lang - определенный язык письма
     *
     * @return String
     */
    public Integer getLangNumber() {
        return documentConverter.log(logger, "Язык номер").byXpath("//lang/text()").asInteger();
    }

    public MessageBody shouldSeeNoReplyNotificationTo(String notification) {
        assertThat(documentConverter.byXpath("//noreply-notification-to").asString(), equalTo(notification));
        return this;
    }
}


