package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Вызов ручки через хендлерс
 * В хендлерсе жестко заданы флаги  XmlStreamerOn,ShowContentMeta'
 */
@OperClass(
        jsxcommand = "message-body",
        jsxpath = "/neo2/handlers/handlers3.jsx",
        jsxprefix = "_handlers",
        description = "Вывод только тела письма через хендлерс"
)
public class MessageBodyHandlers extends Oper<MessageBodyHandlers> {

    /**
     * Получаем timestamp
     *
     * @return String свойство compose_check
     */
    public Long getTimestamp() {
        return documentConverter.byXpath("//info/date/timestamp").as(Long.class);
    }

    /**
     * Получаем user_timestamp
     *
     * @return String свойство compose_check
     */
    public String getUserTimestamp() {
        return documentConverter.byXpath("//info/date/user_timestamp").asString();
    }

    /**
     * Получаем <message-id>
     * (это НЕ mid)
     *
     * @return String свойство compose_check
     */
    public String getMessageId() {
        return documentConverter.byXpath("//info/message-id").asString();
    }

    /**
     * Получаем to/name
     * @return String свойство to/name
     */
    public String getToName() {
        return documentConverter.byXpath("//info/to/name").asString();
    }

    /**
     * Получаем to/email
     * @return String свойство to/name
     */
    public String getToEmail() {
        return documentConverter.byXpath("//info/to/email").asString();
    }
}
