package ru.yandex.autotests.innerpochta.wmi.core.oper;

import com.jayway.jsonpath.JsonPath;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import java.util.List;

import static org.hamcrest.CoreMatchers.hasItem;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.IsNot.not;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 08.11.13
 * Time: 15:13
 */
@OperClass(
        jsxcommand = "message-history-nearest",
        jsxpath = "/neo2/handlers/handlers3.jsx",
        jsxprefix = "_handlers",
        description = "Вывод только тела письма через хендлерс"
)
public class MessageHistoryNearestHandlers extends Oper<MessageHistoryNearestHandlers> {

    public Object handlers() {
        return JsonPath.read(respAsString, "$.handlers");
    }

    public List<String> dataError() {
        return JsonPath.read(handlers(), "$.[*].status");
    }

    public MessageHistoryNearestHandlers notWithError() {
        assertThat("Ручка сломалась ", dataError(), not(hasItem("error")));
        return this;
    }

}
