package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * получить бинарное содержимое части письма
 * /api/message_part?hid=1.2&ids=2340000040468629685&name=1.htm
 */
@OperClass(
        apicommand = "message_part",
        jsxcommand = "message_part",
        description = "Получить бинарное содержимое части письма"
)
public class MessagePart extends Oper<MessagePart> {

    public String arg() {
       return documentConverter.byXpath("//attach_redirect/@arg").asString();
    }

    public String hasPreview() {
        return documentConverter.byXpath("//attach_redirect/@has_preview").asString();
    }


    public MessagePart hasPreviewShouldBeYes() {
        assertThat("Должно быть доступно превью", hasPreview(), equalTo("yes"));
        assertThat("Аргумент в аттач редиректе не должен быть пуст", arg(), not(equalTo("")));
        return this;
    }


    public MessagePart hasPreviewShouldBeNo() {
        assertThat("Аргумент в аттач редиректе должен быть пуст", arg(), equalTo(""));
        assertThat("Не должно быть доступно превью", hasPreview(), equalTo("no"));
        return this;
    }

}
