package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.qatools.allure.annotations.Step;

import static org.apache.commons.lang3.StringUtils.substringBetween;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * <p/>
 * Весьма сомнительный хендлер :)
 * <p/>
 * Хотелось бы знать какую он ручку дергает по этому пути,
 * и как он ее дергает, чтобы была возможность вызвать ее напрямую и единообразно, через simple.jsx
 * <p/>
 * АХТУНГ, возможно большое количество трешака
 * Нужен simple_jsx-160303-0
 */
@OperClass(
        apipath = "/jsxapi/message_source.jsx",
        description = "Просмотр бинарного содержимого письма"
)
public class MessageSource extends Oper<MessageSource> {


    /**
     * Входит ли указанная строка в ответ
     *
     * @param str - строка для поиска
     * @return true, если указанная строка есть в ответе
     */
    public Boolean isThereString(String str) {
        return respAsString.contains(str);
    }
    
    @Step("Ищем заголовок {0} в исходнике письма")
    public String header(String header) {
        return substringBetween(toString(), header + ": ", "\r\n");
    }

    public String messageSource() {
       return respAsString;
    }

    @Step("Ищем заголовок {0} в исходнике письма")
    public String headerJsx(String header) {
        return substringBetween(messageSource(), header + ": ", "\r\n");
    }
}
