package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasXPath;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 23.03.12
 * Time: 14:54
 */
@OperClass(
        jsxcommand = "mobile_get_info",
        description = "Информация о запросившем девайсе"
)
public class MobileGetInfo extends Oper<MobileGetInfo> {

    public MobileGetInfo userAgent(String head) {
        header("User-Agent", head);
        return this;
    }

    public MobileGetInfo browserBase(String browserBase) {
        assertDocument(hasXPath("//BrowserBase/text()", equalTo(browserBase)));
        return this;
    }

    public MobileGetInfo browserBaseVersion(String browserBaseVersion) {
        assertDocument(hasXPath("//BrowserBaseVersion/text()", equalTo(browserBaseVersion)));
        return this;
    }

    public MobileGetInfo browserName(String browserName) {
        assertDocument(hasXPath("//BrowserName/text()", equalTo(browserName)));
        return this;
    }

    public MobileGetInfo isMobile(boolean isMobile) {
        assertDocument(hasXPath("//isMobile/text()", equalTo(String.valueOf(isMobile))));
        return this;
    }


   public MobileGetInfo deviceName(String deviceName) {
       assertDocument(hasXPath("//DeviceName/text()", equalTo(deviceName)));
       return this;
   }

    public MobileGetInfo deviceVendor(String deviceVendor) {
        assertDocument(hasXPath("//DeviceVendor/text()", equalTo(deviceVendor)));
        return this;
    }

    public MobileGetInfo oSFamily(String oSFamily) {
        assertDocument(hasXPath("//OSFamily/text()", equalTo(oSFamily)));
        return this;
    }

    public MobileGetInfo oSVersion(String oSVersion) {
        assertDocument(hasXPath("//OSVersion/text()", equalTo(oSVersion)));
        return this;
    }

    public MobileGetInfo mobileUserAgent(String agent) {
        assertDocument(hasXPath("//mobile_user_agent/text()", equalTo(agent)));
        return this;
    }


}
