package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Метод нужен для вачдога - должен ответить просто понг
 */
@OperClass(
        jsxcommand = "ping",
        apicommand = "ping",
        description = "Пинг-Понг"
)
public class Ping extends Oper<Ping> {

    public String getPong() {
        return documentConverter.byXpath("//ping").asString();
    }

    public Ping pong() {
        assertThat("Неверное значение у аттрибута <pong> ", getPong(), equalTo("pong"));
        return this;
    }
}
