package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.w3c.dom.NodeList;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 */
@OperClass(
        apicommand = "search",
        jsxcommand = "search",
        description = "Поиск писем"
)
public class Search extends Oper<Search> {


    /**
     * @return количество сообщений в выдаче
     */
    public Integer getNumberOfMsgs() {

        NodeList result = documentConverter.byXpath("//message").asNodeList();

        // Логирование
        logger.info("Сообщений: " + result.getLength());

        return result.getLength();
    }

    /**
     * @return количество ссылок в выдаче
     */
    public Integer getNumberOfLinks() {

        NodeList result = documentConverter.byXpath("//link[text()]").asNodeList();
        // Логирование
        logger.info("Ссылок: " + result.getLength());

        return result.getLength();
    }

    /**
     * @return количество ссылок в выдаче
     */
    public Integer getNumberOfAttaches() {

        NodeList result = documentConverter.byXpath("//attachment/@contentType").asNodeList();

        // Логирование
        logger.info("Аттачей: " + result.getLength());

        return result.getLength();
    }

}
