package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matchers;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p>
 * Аналогичен mail_send, за исключением того что не умеет сохранять в черновики,
 * умеет отправлять отложенно и
 * берет отправителя из настроек
 */
@OperClass(
        jsxcommand = "send_message",
        description = "Отправка письма методом send_message"
)
public class SendMessage extends Oper<SendMessage> {

    /**
     * Возвращает значение тега status в выдаче.
     * <p/>
     * Обычно не должен быть пустым и должен быть равен:
     * ok
     *
     * @return String - значение тега результата
     * @throws Exception
     */
    public String getStatusValue() throws Exception {
        assertThat("В ответе присутствует больше одного <status>",
                documentConverter.byXpath("//status").asNodeList().getLength(), Matchers.equalTo(1));
        return Util.getSingleNodeValue(toDocument(), "status");
    }

    public void shouldSeeStatus(String status) throws Exception {
        assertThat(getStatusValue(), equalTo(status));
    }
}
