package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * <p/>
 * DARIA-2234
 * <p/>
 * В некоторых случаях будет приходить пароль (если правило настроено на пересылку, уведомление или автоовет).
 * <p/>
 * С этим паролем надо ходить в блекбокс
 * - и если тот ответил ОК - правило сохранять.
 * - в противном случае возвращать ошибку.
 */
@OperClass(
        jsxcommand = "settings_filter_check_password",
        description = "Проверка пароля в блэкбоксе"
)
public class SettingsFilterCheckPassword extends Oper<SettingsFilterCheckPassword> {


    /**
     * Возвращает результат проверки пароля
     *
     * @return - String ответ - либо false, либо true
     */
    public String getCheckResult() {

        String result = documentConverter.byXpath("//check/text()").asString();

        // Логирование
        logger.info("Результат проверки : " + result);

        return result;
    }

}
