package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Очистка папки от писем
 * Необходимо указывать фид и метод
 * <p/>
 * При отсутствии писем (12-04-2012) Генерирует в лог
 * settings_folder_clear: move_msgs:virtual long long unsigned int yamail::sql_pool::sql_pool_oracle::
 * update(const std::string&, const yamail::sql_pool::data_defs&, bool, yamail::sql_pool::output_vars*):
 * can't update query (2210001110020317375; ; 438023528): move_msgs:sql execute error: ORA-20124: CollectMails -
 * MID list is empty. Nothing to do
 */
@OperClass(
        description = "Очистка папки",
        jsxcommand = "settings_folder_clear",
        apicommand = "settings_folder_clear"
)
public class SettingsFolderClear extends Oper<SettingsFolderClear> {

    public SettingsFolderClear updated(String value) {
        assertThat("Неверное значение <updated>", documentConverter.byXpath("//updated").asString(), equalTo(value));
        return this;
    }
}
