package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderCreateObj;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderCreateObj.empty;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Создание папки с заданным именем
 */
@OperClass(
        jsxcommand = "settings_folder_create",
        apicommand = "settings_folder_create",
        description = "Создание папки"
)
public class SettingsFolderCreate extends Oper<SettingsFolderCreate> {

    public String updated() {
        return documentConverter.byXpath("//updated").asString();
    }

    /**
     * Создание подпапки в папке с известным fid
     *
     * @param folderName - имя подпапки
     * @param parentFID  - фид родительской папки
     */
    public static SettingsFolderCreate newChildFolder(String folderName, String parentFID) {
        return jsx(SettingsFolderCreate.class).params(SettingsFolderCreateObj.newFolder(folderName)
                .setParentId(parentFID));
    }

    /**
     * Создание папки с заданным именем
     *
     * @param folderName - имя папки для создания
     */
    public static SettingsFolderCreate newFolder(String folderName) {
        return jsx(SettingsFolderCreate.class).params(empty().setFolderName(folderName));
    }

    /**
     * Создание папки с рандомным именем
     */
    public static SettingsFolderCreate newFolder() {
        return jsx(SettingsFolderCreate.class).params(empty().setFolderName(Util.getRandomString()));
    }
}
