package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderDeleteObj;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Удаление папки с заданным именем
 */
@OperClass(
        jsxcommand = "settings_folder_delete",
        apicommand = "settings_folder_delete",
        description = "Удаление папки"
)
public class SettingsFolderDelete extends Oper<SettingsFolderDelete> {

    public static SettingsFolderDelete delete(String fid) {
        return jsx(SettingsFolderDelete.class)
                .params(SettingsFolderDeleteObj.deleteOneFolder(fid));
    }

    public static SettingsFolderDelete forceDelete(String folderFid) {
        return jsx(SettingsFolderDelete.class)
                .params(SettingsFolderDeleteObj.deleteOneFolder(folderFid).setForce("yes"));
    }
}
