package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderDeleteObj;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "settings_folder_delete_with_msgs",
        description = "Удаление папки с сообщениями"
)
public class SettingsFolderDeleteWithMsgs extends Oper<SettingsFolderDeleteWithMsgs> {

    public static SettingsFolderDeleteWithMsgs deleteWithMsgs(String folderFid) {
        return jsx(SettingsFolderDeleteWithMsgs.class)
                .params(SettingsFolderDeleteObj.deleteOneFolder(folderFid));
    }

    public static SettingsFolderDeleteWithMsgs forceDeleteWithMsgs(String folderFid) {
        return jsx(SettingsFolderDeleteWithMsgs.class)
                .params(SettingsFolderDeleteObj.deleteOneFolder(folderFid).setForce("yes"));
    }

}
