package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderMoveObj;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/8/13
 * Time: 6:24 PM
 */

/**
 * DARIA-1690
 */
@OperClass(
        jsxcommand = "settings_folder_move",
        description = "Перемещение папки между уровнями"
)
public class SettingsFolderMove extends Oper<SettingsFolderMove> {

    /**
     * Перемещает подпапку с заданным fid в
     * папку с заданным fid
     *
     * @param fid       - фид папки, которую переносим
     * @param parentFid - фид папки, под которую переносим,
     *                   если равен 0 переносим на вверхний уровень
     * @return SettingsFolderRenameObj
     */
    public static SettingsFolderMove move(String fid, String parentFid) {
        //DARIA-49596
        String connectionId = Util.getRandomString();
        System.out.println(connectionId);
        return jsx(SettingsFolderMove.class)
                .params(SettingsFolderMoveObj
                        .move()
                        .setConnectionId(connectionId)
                        .setFid(fid)
                        .setParentFid(parentFid));
    }
}
