package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderSetOptionsObj;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * * WMI-103
 * Устанавливает опции внутри тега
 * <folder_options>{"threaded": "?","notify": "1"}</folder_options>
 * передавать нужно все опции, даже если меняется одна
 * пример запроса: simple.jsx?wmi-method=settings_folder_set_options&fid=<fid>&threaded=?&notify=1
 * [@]param params fid, notify, threaded и другие, если появятся
 * <p/>
 * DARIA-1690
 * Ручка называется settings_folder_set_options, принимает fid (фид папки, позицию которой надо изменить),
 * prev (фид папки, ПОСЛЕ которой надо расположить папку, позицию которой мы меняем, либо 0 в случае,
 * если папку необходимо расположить первой в списке).
 * Результаты можно видеть в атрибуте position ноды folder_options выдачи folder_list - целые числа,
 * определяющие порядок по возрастанию (позиции идут не подряд, значение имеет только стандартное отношение порядка).
 * Позиционирование ограничивается уровнем вложенности, то есть для каждого уровня (множества папок,
 * имеющих общего предка) имеется своя очередность.
 * До тех пор, пока пользователь ничего не двигал, позиции не заданы.
 * При первом использовании функциональности происходит инициализирование позиций в лексикографическом порядке.
 * Если позиции инициализированы, то при создании папки или перемещении папки из другой ветки иерархии
 * папке присваивается последняя позиция на своем уровне.
 * В целях оптимизации запросов к базе, начальные позиции имеют стократный коэффициент,
 * что позволяет при необходимости перемещения папки между двумя другими папками, имеющими позиции 100 и 200,
 * задать ей позицию 150 и не модифицировать соседние папки (меньше запросов к ораклу).
 * При невероятно активном использовании функциональности позиции двух папок можно свести к последовательным значениям
 * (например, 100 и 101 при семикратной перемене мест второй и третьей папки).
 * В этом случае запускается переинициализация, восстанавливающая интервалы.
 * jkennedy@
 */

@OperClass(
        jsxcommand = "settings_folder_set_options",
        description = "Обновление настройки folder_options для конкретной папки"
)
public class SettingsFolderSetOptions extends Oper<SettingsFolderSetOptions> {

    public static final String NOTIFY_UNKN = "?";
    public static final String THREADED_UNKN = "?";

    /**
     * DARIA-1690
     * Создает объект для расположения папки первой в списке
     *
     * @param fid - фид папки, позицию которой надо изменить
     * @return SettingsFolderSetOptionsObj
     */
    public static SettingsFolderSetOptions firstPlaceSortOptions(String fid) {
        return jsx(SettingsFolderSetOptions.class)
                .params(SettingsFolderSetOptionsObj
                        .empty()
                        .setSortOptions(fid, "0", NOTIFY_UNKN, THREADED_UNKN));
    }

    /**
     * DARIA-1690
     * Создает объект для расположения папки после папки
     *
     * @param fid  - фид папки, позицию которой надо изменить
     * @param prev - фид папки, ПОСЛЕ которой надо расположить папку, позицию которой мы меняем, либо 0 в случае,
     *             если папку необходимо расположить первой в списке
     * @return SettingsFolderSetOptionsObj
     */
    public static SettingsFolderSetOptions setSortOptions(String fid, String prev) {
        return jsx(SettingsFolderSetOptions.class)
                .params(SettingsFolderSetOptionsObj
                        .empty()
                        .setSortOptions(fid, prev, NOTIFY_UNKN, THREADED_UNKN));
    }

    /**
     * DARIA-1690
     * Создает объект для расположения папки
     *
     * @param fid      - фид папки, позицию которой надо изменить
     * @param prev     - фид папки, ПОСЛЕ которой надо расположить папку, позицию которой мы меняем, либо 0 в случае,
     *                 если папку необходимо расположить первой в списке
     * @param notify
     * @param threaded
     * @return SettingsFolderSetOptionsObj
     */
    public static SettingsFolderSetOptions setSortOptions(String fid, String prev, String notify, String threaded) {
        return jsx(SettingsFolderSetOptions.class)
                .params(SettingsFolderSetOptionsObj
                        .empty()
                        .setSortOptions(fid, prev, notify, threaded));
    }

    public SettingsFolderSetOptions updated(Matcher<String> matcher) {
        assertThat("Результат выводимый в теге updated не совпадает с ожиданием",
                documentConverter.byXpath("//updated").asString(), matcher);
        return this;
    }
}
