package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsLabelCreateObj;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "settings_label_create",
        apicommand = "settings_label_create",
        description = "Создание метки"

)
public class SettingsLabelCreate extends Oper<SettingsLabelCreate> {

    public String updated() {
        String lid = documentConverter.byXpath("//updated").asString();
        logger.info("Создана: " + lid);

        return lid;
    }

    public static SettingsLabelCreate newLabel(String name, String color) {
        return jsx(SettingsLabelCreate.class)
                .params(SettingsLabelCreateObj.empty()
                        .setLabelName(name)
                        .setLabelColor(color));
    }

    public static SettingsLabelCreate newLabel(String name) {
        return jsx(SettingsLabelCreate.class)
                .params(SettingsLabelCreateObj.newLabel(name));
    }

    public static SettingsLabelCreate newLabel() {
        return jsx(SettingsLabelCreate.class)
                .params(SettingsLabelCreateObj.newLabel(Util.getRandomString()));
    }
}
