package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsLabelDeleteObj;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        apicommand = "settings_label_delete",
        jsxcommand = "settings_label_delete",
        description = "Удаление одной метки"
)
public class SettingsLabelDelete extends Oper<SettingsLabelDelete> {

    /**
     * Удаление метки по lid-у
     *
     * @param
     * @throws java.io.IOException
     */
    public static SettingsLabelDelete deleteLabel(String lid) {
       return jsx(SettingsLabelDelete.class).params(SettingsLabelDeleteObj.oneLid(lid));
    }

    public static SettingsLabelDelete deleteLabel(String... lid) {
        return jsx(SettingsLabelDelete.class).params(SettingsLabelDeleteObj.lids(lid));
    }
}
