package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsLabelRenameObj.renameLabelObj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Изменение параметров метки - имени, цвета по заданному lid
 */
@OperClass(
        jsxcommand = "settings_label_rename",
        apipath = "/neo/ajax/",
        apicommand = "action_label_edit",
        description = "Изменение метки"

)
public class SettingsLabelRename extends Oper<SettingsLabelRename> {

    public static SettingsLabelRename settingsLabelRename(Obj params) {
        return jsx(SettingsLabelRename.class).params(params);
    }

    public static SettingsLabelRename renameLabel(String lid, String labelName) {
        return jsx(SettingsLabelRename.class).params(renameLabelObj(lid, labelName));
    }
}
