package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        apicommand = "settings_rpopper_create",
        description = "Создание сборщика pop"
)
public class SettingsRpopperCreate extends Oper<SettingsRpopperCreate> {


    /**
     * Возвращает id нового добавленного сборщика
     *
     * @return - String popperID
     */
    public String getPopperId() {
        return documentConverter.log(logger, "PID").byXpath("//popid/text()").asString();
    }

    public SettingsRpopperCreate shouldBePopid(Matcher<String> matcher) {
        assertThat(getPopperId(), matcher);
        return this;
    }

}
