package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        apicommand = "settings_rpopper_edit",
        description = "Редактирование сборщика pop"
)
public class SettingsRpopperEdit extends Oper<SettingsRpopperEdit> {

    public String getPopperId() {
        return documentConverter.log(logger, "PID").byXpath("//popid/text()").asString();
    }

    public String getUpdated() {
        return documentConverter.byXpath("//updated/text()").asString();
    }

    public SettingsRpopperEdit shouldBePopid(Matcher<String> matcher) {
        assertThat(getPopperId(), matcher);
        return this;
    }

    public SettingsRpopperEdit shouldBeOk() {
        assertThat(getUpdated(), equalTo("ok"));
        return this;
    }

}
