package ru.yandex.autotests.innerpochta.wmi.core.oper;

import com.google.common.base.Joiner;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsRpopperCreateObj;

import java.util.List;

import static com.jayway.restassured.path.xml.XmlPath.from;
import static org.hamcrest.CoreMatchers.hasItem;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        apicommand = "settings_rpopper_list",
        description = "Вывод списка сборщиков pop"
)
public class SettingsRpopperList extends Oper<SettingsRpopperList> {


    /**
     * Получает все id сборшиков как список
     *
     * @return ArrayList - список id сборщиков
     */
    public List<String> getAllRpoppers() {
        return documentConverter.byXpath("//popid/text()").asList();
    }

    public SettingsRpopperList hasPopid(String popid) {
          assertThat(getAllRpoppers(), hasItem(popid));
          return this;
    }

    /**
     * Проверяет есть ли нужный сборщик
     *
     * @param pID     - id сборщика для поиска
     * @param rpopper - набор параметров для проверки
     *
     * @return true, если сборщик с такими параметрами есть и он один
     */
    public Boolean isRpopperCreated(String pID, SettingsRpopperCreateObj rpopper) {
        logger.info(Joiner.on("\n").join(
                respAsString,
                from(respAsString).get("**.find { it.name() == 'popid' } ") + " - " + pID,
                from(respAsString).get("**.find { it.name() == 'server'}") + " - " + rpopper.getServer(),
                from(respAsString).get("**.find { it.name() == 'port'}") + " - " + rpopper.getPort(),
                from(respAsString).get("**.find { it.name() == 'login'}") + " - " + rpopper.getLogin(),
                from(respAsString).get("**.find { it.name() == 'use_ssl'}") + " - " + rpopper.getUseSsl(),
                from(respAsString).get("**.find { it.name() == 'email'}") + " - " + rpopper.getEmail(),
                from(respAsString).get("**.find { it.name() == 'enable_status'}") + " - " + "1",
                from(respAsString).get("**.find { it.name() == 'enable'}") + " - " + "1",
                from(respAsString).get("**.find { it.name() == 'no_delete_msg' }") + " - " + rpopper.getNoDeleteMsg()));

        return documentConverter.byXpath("count(//item[" +
                "popid='" + pID + "' " +
                "and server='" + rpopper.getServer() + "' " +
                "and port='" + rpopper.getPort() + "' " +
                "and login='" + rpopper.getLogin() + "' " +
                "and use_ssl='" + rpopper.getUseSsl() + "' " +
                "and email='" + rpopper.getEmail() + "' " +
                "and enable_status='1' " +
                "and enable='1' " +
                "and no_delete_msg='" + rpopper.getNoDeleteMsg() + "']) = 1").asBoolean();
    }

}
