package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        apicommand = "settings_setup",
        jsxcommand = "settings_setup",
        description = "Отображение настроек пользователя"
)
public class SettingsSetup extends Oper<SettingsSetup> {

    public SettingsSetup settingShouldBe(String setting, String value) {
        assertThat("Значение настройки " + setting + " не совпадает с ожидаемым: ",
                getSettingValue(setting), is(value));
        return this;
    }

    /**
     * Получает значение настройки
     *
     * @param name имя настройки
     * @return Строка значение
     */
    public String getSettingValue(String name) {
        return documentConverter.log(logger, "Получено - '" + name + "'").byXpath("//" + name).asString();
    }


    /**
     * Проверяет значение, сравнивая с ожидаемым
     *
     * @param name          настройка
     * @param expectedValue ожидаемое значение
     * @return true если равны
     */
    public boolean isSettingEquals(String name, String expectedValue) {
        String settingValue = getSettingValue(name);
        return (expectedValue.equals(settingValue));
    }


    /**
     * Проверяет наличие настройки
     *
     * @param name название
     * @return true если нашел
     */
    public Boolean isThereSetting(String name) {
        try {
            return Util.isThereNode(toDocument(), name);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
