package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import ru.yandex.autotests.innerpochta.beans.Envelope;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.Mops;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.source.MidsSource;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.utils.WaitedMailbox;
import ru.yandex.autotests.innerpochta.wmi.core.utils.FolderList;

import java.util.Arrays;
import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.mops.MopsResponses.okSync;
import static ru.yandex.autotests.innerpochta.wmi.core.utils.SendbernarUtils.sendWith;

public class Tabs {
    public enum Tab {
        EMPTY(""),
        NEWS("news"),
        SOCIAL("social"),
        RELEVANT("relevant");

        public String getName() {
            return this.name;
        }

        Tab(String name) {
            this.name = name;
        }

        private String name;

        public static final String defaultTab = Tab.RELEVANT.getName();
    }

    public static Object[][] existingTabs() {
        return new Object[][] {
                { Tab.RELEVANT },
                { Tab.NEWS },
                { Tab.SOCIAL }
        };
    }

    private static void markMessagesForTab(HttpClientManagerRule authClient,
                                           List<String> mids, Tab tab) throws Exception {
        Mops.complexMove(authClient, (new FolderList(authClient)).inboxFID(), tab.getName(), new MidsSource(mids))
                .post(shouldBe(okSync()));
    }

    public static void markMessageForTab(HttpClientManagerRule authClient,
                                         String mid, Tab tab) throws Exception {
        markMessagesForTab(authClient, Arrays.asList(mid), tab);
    }

    public static List<String> makeMessagesForTab(HttpClientManagerRule authClient,
                                                  int count, Tab tab) throws Exception {
        List<String> mids = sendWith(authClient).viaProd().count(count).send().waitDeliver().getMids();
        markMessagesForTab(authClient, mids, tab);

        return mids;
    }

    public static String makeMessageForTab(HttpClientManagerRule authClient, Tab tab) throws Exception {
        List<String> mids = makeMessagesForTab(authClient, 1, tab);
        return mids.get(0);
    }

    public static Pair<String, List<String>> makeThreadForTab(HttpClientManagerRule authClient, Tab tab) throws Exception {
        WaitedMailbox msgs = sendWith(authClient).viaProd().count(2).send().waitDeliver();
        markMessagesForTab(authClient, msgs.getMids(), tab);
        return new ImmutablePair<>(msgs.getTid(), msgs.getMids());
    }

    public static Envelope makeEnvelopeForTab(HttpClientManagerRule authClient, Tab tab) throws Exception {
        Envelope envelope = sendWith(authClient).viaProd().send().waitDeliver().getEnvelope().get();
        markMessageForTab(authClient, envelope.getMid(), tab);
        return envelope;
    }

    public static Pair<String, List<String>> makeThreadForMultiTabs(HttpClientManagerRule authClient,
                                                                    List<Tab> tabs) throws Exception {
        WaitedMailbox msgs = sendWith(authClient).viaProd().count(tabs.size()).send().waitDeliver();
        List<String> mids = msgs.getMids();
        for (int i = 0; i < tabs.size(); i++) {
            markMessageForTab(authClient, mids.get(i), tabs.get(i));
        }
        return new ImmutablePair<>(msgs.getTid(), mids);
    }
}
