package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.w3c.dom.NodeList;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import javax.xml.xpath.XPathExpressionException;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * получаем заголовки тредов для всех писем (в случае одного письма будет тред с одним письмом)
 */
@OperClass(
        apicommand = "thread_list",
        jsxcommand = "thread_list",
        description = "Получаем заголовки тредов"
)
public class ThreadList extends Oper<ThreadList> {


    /**
     * Считает количество сообщений в теме
     *
     * @return Integer - количество писем в теме
     */
    public Integer countMessagesInThread() {
        NodeList nodes = documentConverter.byXpath("//message").asNodeList();
        Integer cnt = nodes.getLength();

        // Логирование
        logger.info("Сообщений в данном треде: " + cnt);

        return cnt;
    }


    /**
     * Проверка что все сообщения в теме имеют одинаковую заданную тему
     *
     * @param subject тема
     * @return Boolean - true если все письма с одинаковой темой
     */
    public Boolean allMessagesHasTheSameSubject(String subject) {

        NodeList nodes = documentConverter.byXpath("//message/subject/text()").asNodeList();
        Boolean isAllTheSame = true;
        for (int i = 0; i < nodes.getLength(); i++) {
            if (!nodes.item(i).getNodeValue().equals(subject)) {
                isAllTheSame = false;
            }
        }
        return isAllTheSame;
    }


    /**
     * Получает миды всех писем из выдачи
     *
     * @return List<String> midы писем
     */
    public List<String> getAllMids() {
        return documentConverter.byXpath("//message/@mid").asList();
    }


    /**
     * Возвращает число в атрибуте att_count при совпадении mid
     *
     * @param mid - mid письма
     * @return Integer         - Число аттачей
     * @throws javax.xml.xpath.XPathExpressionException
     *          *
     */
    public Integer getAttCount(String mid) throws XPathExpressionException {
        return documentConverter.byXpath("//message[@mid='" + mid + "']/@att_count").asInteger();
    }


}
