package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.w3c.dom.NodeList;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.ThreadsViewObj;

import javax.xml.xpath.XPathExpressionException;
import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        apicommand = "threads_view",
        jsxcommand = "threads_view",
        description = "Просмотр ящика в виде тредов"
)
public class ThreadsView extends Oper<ThreadsView> {


    public static ThreadsView threadsViewJsxDaria2() {
        return jsx(ThreadsView.class).params(new ThreadsViewObj().setXmlVersion(ThreadsViewObj.XMLVERSION_DARIA2));
    }


    /**
     * Получает ид темы по заголовку темы
     *
     * @param subject - тема
     * @return String - id темы
     */
    public String getThreadId(String subject) {

        String threadId = documentConverter.byXpath("//message[subject/text='" + subject + "']/@thread_id").asString();

        // Логирование
        logger.info("Thread_id: " + threadId + " с темой - " + subject);

        return threadId;
    }


    /**
     * Проверка что тема помечена меткой
     *
     * @param threadId - ид темы
     * @param labelId  - ид метки
     * @return Boolean true если помечена
     */
    public Boolean isThreadLabeled(String threadId, String labelId) {
        return documentConverter.byXpath("count(//message[@thread_id='"
                + threadId + "' and lids/item='"
                + labelId + "']) > 0").asBoolean();
    }


    /**
     * Все лиды
     *
     * @param threadId - ид темы
     */
    public List<String> threadLids(String threadId) {
        return documentConverter.byXpath("//message[@thread_id='" + threadId + "']/lids/item/text()").asList();
    }


    /**
     * Возвращает первый попавшийся ид треда
     *
     * @return String - ид треда
     */
    public String getAnyThreadId() {

        String threadId = documentConverter.byXpath("//message[@thread_id]/@thread_id").asString();

        // Логирование
        logger.info("Полученный случайный thread_id: " + threadId);

        return threadId;
    }


    /**
     * Возвращает количество любых отображенных писем
     * Отображенных = если меньше настройки отображения, то реальное кол-во,
     * если больше настройки, то настройку
     * Для более точного числа во всей папке, нужно использовать getMessageCounter()
     *
     * @return Целочисленное количество отображенных писем в папке
     */
    public Integer countMessages() {
        NodeList nodes = documentConverter.byXpath("//message").asNodeList();
        return nodes.getLength();
    }

    /**
     * Получает миды всех писем из выдачи
     *
     * @return List<String> midы писем
     */
    public List<String> getAllMids() {
        return documentConverter.byXpath("//message/@mid").asList();
    }


    /**
     * Получает миды всех писем из выдачи
     *
     * @return List<String> midы писем
     */
    public List<String> getAllRecvDates() {
        return documentConverter.byXpath("//message/@recv_date").asList();
    }


    public Integer getAttCount(String mid) throws XPathExpressionException {
        String attCount = documentConverter.byXpath("//message[@mid='" + mid + "']/@att_count").asString();
        return Integer.parseInt(attCount);
    }

    /**
     * <thread_scn>888253636426</thread_scn>
     * @return
     */
    public String getScn(String threadId) {
        return documentConverter.byXpath("//messages/list/thread[@id='" + threadId + "']/thread_scn").asString();
    }

}
