package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.UnsubscribeObj;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 03.06.16
 * Time: 17:31
 */
@OperClass(
        jsxcommand = "unsubscribe",
        description = "Отписываемся от рассылки"
)
public class Unsubscribe extends Oper<Unsubscribe> {


    public static Unsubscribe unsubscribe(String mid)  {
        return jsx(Unsubscribe.class).params(UnsubscribeObj.emty().setIds(mid));
    }


    public Unsubscribe resultOk() {
        assertThat("Должен быть результат OK", getResultValue(),
                equalTo("ok"));
        return this;
    }

    public String getResultValue() {
        return documentConverter.byXpath("//status/@reason").asString();
    }
}
