package ru.yandex.autotests.innerpochta.wmi.core.oper.akita;

import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.ResponseSpecification;
import org.apache.http.HttpStatus;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import ru.yandex.autotests.innerpochta.beans.akita.*;
import ru.yandex.autotests.innerpochta.wmi.core.akita.ApiAkita;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiAkita;
import static ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule.xOriginalHost;


public class AkitaAuth implements UidAndTvmTicket {
    private static ResponseSpecification okAuth() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody("account_information", notNullValue())
                .build();
    }

    private String uid;
    private String suid;
    private String userTicket;

    private Map<String, String> cookies(DefaultHttpClient authHC) {
        return authHC.getCookieStore().getCookies()
                .stream()
                .collect(Collectors.toMap(Cookie::getName, Cookie::getValue));
    }

    private void accountInformation(ApiAkita api, String xOriginalHost) {
        Response authRes = api.auth()
                .withXoriginalhostHeader(xOriginalHost)
                .get(shouldBe(okAuth()));
        AccountInformation nonFrozenAccount = authRes
                .as(AuthResponse.class)
                .getAccountInformation();
        if (Objects.nonNull(nonFrozenAccount.getAccount())) {
            Account acc = nonFrozenAccount.getAccount();
            uid = acc.getUserId();
            suid = acc.getServiceUserId();
            userTicket = nonFrozenAccount.getUserTicket();
            return;
        }

        AccountInformation_ acc = authRes.as(AuthUserIsFrozenResponse.class).getAccountInformation();
        uid = acc.getUserId();
        suid = acc.getUserId();
        userTicket = nonFrozenAccount.getUserTicket();

    }

    public AkitaAuth(DefaultHttpClient authHC) {
        accountInformation(apiAkita(cookies(authHC)), xOriginalHost());
    }

    public AkitaAuth(DefaultHttpClient authHC, String url, String xOriginalHost) {
        accountInformation(apiAkita(cookies(authHC), url), xOriginalHost);
    }

    @Override
    public String userTicket() {
        return userTicket;
    }

    @Override
    public String uid() {
        return uid;
    }

    @Override
    public String suid() {
        return suid;
    }
}
