package ru.yandex.autotests.innerpochta.wmi.core.oper.akita;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;

import static ch.lambdaj.function.matcher.NotNullOrEmptyMatcher.notNullOrEmpty;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 9/18/13
 * Time: 1:10 PM
 */
@OperClass(
        description = "Запрос к yplatform. Авторизация",
        apicommand = "",
        apipath = "/auth"
)
public class Auth extends Oper<Auth> {

    private String defaultAddress() {
        return JsonPath.read(respAsString, "$.account_information.addresses.defaultAddress");
    }

    public Auth defaultAddress(Matcher<String> matcher) {
        assertThat("Неверное значение у аттрибута <defaultAddress> ", defaultAddress(), matcher);
        return this;
    }

    public Auth emptyDefaultAddress() {
        assertThat("Неверное значение у аттрибута <defaultAddress> ", defaultAddress(), equalTo(""));
        return this;
    }

    public List<String> services() {
            return JsonPath.read(respAsString, "$.[*].account_information.services");
    }

    public Auth code(Matcher<Integer> matcher) {
        assertThat("Неверное значение поля <code>", getIntFromJson("error.code"), matcher);
        return this;
    }

    public Auth message(Matcher<String> matcher) {
        assertThat("Неверное значение поля <message>", getStringFromJson("error.message"), matcher);
        return this;
    }

    public Auth reason(Matcher<String> matcher) {
        assertThat("Неверное значение поля <reason>", getStringFromJson("error.reason"), matcher);
        return this;
    }

    public Auth nonEmptyTicket(){
        assertResponse(containsString("ticket"));
        assertThat("Пустое поле <ticket>", getStringFromJson("account_information.ticket"), notNullOrEmpty());
        return this;
    }

    public Auth bbAttribute(String attrName, Matcher<String> matcher) {
        assertThat("", getStringFromJson("account_information.account.attributes." + attrName), matcher);
        return this;
    }

    public Auth nonEmptyConnectionId(){
        assertResponse(containsString("bbConnectionId"));
        assertThat("Пустое поле <bbConnectionId>",
                getStringFromJson("account_information.account.bbConnectionId"), notNullOrEmpty());
        return this;
    }

    public String uid() {
        return getStringFromJson("account_information.account.userId");
    }
}
