package ru.yandex.autotests.innerpochta.wmi.core.oper.blackbox;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.EmptyObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Random;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * в sjsx нету
 */
@OperClass(
        jsxpath = "/blackbox",
        jsxprefix = "method",
        jsxcommand = "login",
        description = "Получение токена из ББ"
)
public class BlackBoxLoginMethod extends Oper<BlackBoxLoginMethod> {

    public static BlackBoxLoginMethod bbLoginMethod(String login, String pwd)
            throws UnknownHostException, InterruptedException {

        String ip = Inet4Address.getLocalHost().getHostAddress();

        Thread.sleep(new Random().nextInt(5000));

        return jsx(BlackBoxLoginMethod.class).setHost(props().blackboxHost())
                .params(new EmptyObj()
                        .set("sid", "smtp")
                        .set("login", login)
                        .set("password", pwd)
                        .set("userip", ip)
                );
    }

}
