package ru.yandex.autotests.innerpochta.wmi.core.oper.handlers;

import com.jayway.jsonpath.JsonPath;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * Получение секретного ключа
 * https://mail.yandex.ru/neo2/handlers/handlers3.jsx?_handlers=secret-key
 */
@OperClass(
        jsxcommand = "secret-key",
        jsxpath = "/neo2/handlers/handlers3.jsx",
        jsxprefix = "_handlers",
        description = "Получение секретного ключа"
)
public class SecretKeyHandlers3 extends Oper<SecretKeyHandlers3> {

    public String sk() {
        String sk = JsonPath.read(respAsString, "$.handlers[0].data.key");
        logger.info("Secret-Key: " + sk);
        return sk;
    }
}
