package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 10.09.14
 * Time: 14:03
 */
@OperClass(
        description = "Запрос к yplatform. Выдаем значения счётчиков из meta",
        apicommand = "",
        apipath = "/counters"
)
public class Counters extends Oper<Counters> {
    
    public static Counters counters(Obj params) {
        return api(Counters.class).setHost(props().houndUri()).params(params);
    }

    public Integer fresh() {
        return JsonPath.read(respAsString, "$.counters.fresh");
    }

    public Integer unread() {
       return JsonPath.read(respAsString, "$.counters.unread");
    }

    public Counters freshShouldBe(Matcher<Integer> matcher) {
        assertThat("Неверное значение у аттрибута <fresh> ", fresh(), matcher);
        return this;
    }

    public Counters unreadShouldBe(Matcher<Integer> matcher) {
        assertThat("Неверное значение у аттрибута <unread> ", unread(), matcher);
        return this;
    }

}
