package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import ru.yandex.autotests.innerpochta.beans.ByTimestampResp;
import ru.yandex.autotests.innerpochta.beans.Envelope;
import ru.yandex.autotests.innerpochta.beans.yplatform.Error;
import ru.yandex.autotests.innerpochta.beans.yplatform.DeletedMessage;
import ru.yandex.autotests.innerpochta.beans.yplatform.MidsWithStids;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;

@OperClass(
        description = "Запрос к yplatform. Выборка удаленных писем",
        apipath = "/deleted_messages"
)
public class DeletedMessages extends Oper<DeletedMessages> {
    public List<DeletedMessage> midsAndStids() {
        return fromJson(MidsWithStids.class).getDeletedMessages();
    }

    public List<Envelope> envelopes() {
        return fromJson(ByTimestampResp.class).getEnvelopes();
    }

    public Error parsed() {
        return fromJson(MidsWithStids.class).getError();
    }
}
