package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.beans.yplatform.FilterSearch;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;
import java.util.Map;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 16.10.13
 * Time: 15:43
 */
@OperClass(
        description = "Запрос к yplatform. Фильтрация списка писем используя заданные фильтры",
        apicommand = "",
        apipath = "/filter_search"
)
public class FilterSearchCommand extends Oper<FilterSearchCommand> {

    public static FilterSearchCommand filterSearch(Obj params) {
        return api(FilterSearchCommand.class).setHost(props().houndUri())
                .params(params);
    }

    public String displayNameFrom() {
        return getStringFromJson("envelopes[0].from[0].displayName");
    }

    public String domainTo() {
        return getStringFromJson("envelopes[0].to[0].domain");
    }

    public String subject() {
        return getStringFromJson("envelopes[0].subject");
    }

    public Map<String, String> from() {
        return getListFromJson("envelopes[0].from").get(0);
    }

    public List<Map<String, String>> to() {
        return getListFromJson("envelopes[0].to");
    }

    public List<Map<String, String>> cc() {
        return getListFromJson("envelopes[0].cc");
    }

    public List<Map<String, String>> bcc() {
        return getListFromJson("envelopes[0].bcc");
    }

    public String firstline() {
        return getStringFromJson("envelopes[0].firstline");
    }

    public String tab() {
        return getStringFromJson("envelopes[0].tab");
    }

    public FilterSearchCommand code(Matcher<Integer> matcher) {
        assertThat("Неверное значение поля <code>", getIntFromJson("error.code"), matcher);
        return this;
    }

    public FilterSearchCommand message(Matcher<String> matcher) {
        assertThat("Неверное значение поля <message>", getStringFromJson("error.message"), matcher);
        return this;
    }

    public FilterSearchCommand reason(Matcher<String> matcher) {
        assertThat("Неверное значение поля <reason>", getStringFromJson("error.reason"), matcher);
        return this;
    }

    public FilterSearch parsed() {
        return fromJson(FilterSearch.class);
    }
}