package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 11.11.15
 * Time: 14:59
 */
@OperClass(
        description = "Запрос к yplatform. Рисуем пейджер по датам внизу списка писем",
        apicommand = "",
        apipath = "/first_envelope_date"
)
public class FirstEnvelopeDate extends Oper<FirstEnvelopeDate> {

    public static FirstEnvelopeDate firstEnvelopeDate(Obj params) {
        return api(FirstEnvelopeDate.class).setHost(props().houndUri()).params(params);
    }

    public long firstEnvelopeData() {
        return Integer.toUnsignedLong(JsonPath.read(respAsString, "$.first_envelope_date"));
    }

    public FirstEnvelopeDate shouldBeDate(long expectedDate) {
        assertThat("Ожидали другое значение поля <first_envelope_date>", firstEnvelopeData(), equalTo(expectedDate));
        return this;
    }

    public FirstEnvelopeDate code(Matcher<Integer> matcher) {
        assertThat("Неверное значение поля <code>", getIntFromJson("error.code"), matcher);
        return this;
    }

    public FirstEnvelopeDate message(Matcher<String> matcher) {
        assertThat("Неверное значение поля <message>", getStringFromJson("error.message"), matcher);
        return this;
    }

    public FirstEnvelopeDate reason(Matcher<String> matcher) {
        assertThat("Неверное значение поля <reason>", getStringFromJson("error.reason"), matcher);
        return this;
    }
}