package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matchers;
import org.junit.Assert;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

@OperClass(
        description = "Запрос к hound. Счётчики непрочитанных писем для табов в папке",
        apicommand = "",
        apipath = "/folder_tabs_new_counters"
)
public class FolderTabsNewCounters extends Oper<FolderTabsNewCounters> {

    public static FolderTabsNewCounters folderTabsNewCounters(Obj params) {
        return api(FolderTabsNewCounters.class).setHost(props().houndUri()).params(params);
    }

    public int newMessagesCount(String tab) {
        return JsonPath.read(respAsString, "$.new_counters." + tab);
    }

    public FolderTabsNewCounters expectNewMessagesInTab(int newCount, String tab) {
        Assert.assertThat(newMessagesCount(tab), Matchers.equalTo(newCount));
        return this;
    }
}
