package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.jayway.jsonpath.JsonPath;
import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.beans.yplatform.Fid;
import ru.yandex.autotests.innerpochta.beans.yplatform.Folder;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.Map;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 04.10.13
 * Time: 16:16
 */
@OperClass(
        description = "Запрос к hound. Папки",
        apicommand = "",
        apipath = "/folders"
)
public class Folders extends Oper<Folders> {

    public static Folders folders(Obj params) {
        return api(Folders.class).setHost(props().houndUri()).params(params);
    }

    public Boolean getUnvisited(String fid) {
            return JsonPath.read(respAsString, "$.folders." + fid + ".unvisited");
    }

    public Folders errorCode(int sharpeiErrorCode) {
        assertThat(JsonPath.read(respAsString, "$.error.code"), equalTo(sharpeiErrorCode));
        return this;
    }

    public boolean isFolderThreaded(String fid) {
        return JsonPath.read(respAsString, "$.folders." + fid + ".isThreadable");
    }

    public String name(Symbol symbol) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> lids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        Optional<Map.Entry<String, Fid>> fidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getSymbolicName()
                                .getTitle()
                                .equals(symbol.toString()))
                .findFirst();
        return fidEntry.isPresent() ? fidEntry.get().getValue().getName() : null;
    }

    public String name(String fid) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> lids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        Optional<Map.Entry<String, Fid>> fidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getKey()
                                .equals(fid))
                .findFirst();
        return fidEntry.isPresent() ? fidEntry.get().getValue().getName() : null;
    }

    public String fid(Symbol symbol) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> lids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        Optional<Map.Entry<String, Fid>> fidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getSymbolicName()
                                .getTitle()
                                .equals(symbol.toString()))
                .findFirst();
        return fidEntry.isPresent() ? fidEntry.get().getKey() : null;
    }

    public String symbolName(String name) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> lids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        Optional<Map.Entry<String, Fid>> fidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getKey()
                                .equals(name))
                .findFirst();
        return fidEntry.isPresent() ? fidEntry.get().getValue().getSymbolicName().getTitle() : null;
    }

    public String fid(String name) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> lids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        Optional<Map.Entry<String, Fid>> fidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getName()
                                .equals(name))
                .findFirst();
        return fidEntry.isPresent() ? fidEntry.get().getKey() : null;
    }

    public Integer count(String fid) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> fids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());

        Optional<Integer> count = fids
                .entrySet()
                .stream()
                .filter(
                        (entry -> entry
                                .getKey()
                                .equals(fid))
                )
                .map(
                        (entry -> entry
                                .getValue()
                                .getMessagesCount()
                                .intValue())
                )
                .findFirst();

        return count.orElse(null);
    }

    public Integer newCount(String fid) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> fids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());

        Optional<Integer> count = fids
                .entrySet()
                .stream()
                .filter(
                        (entry -> entry
                                .getKey()
                                .equals(fid))
                )
                .map(
                        (entry -> entry
                                .getValue()
                                .getNewMessagesCount()
                                .intValue())
                )
                .findFirst();

        return count.orElse(null);
    }

    public List<String> nonsystemFids() {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> fids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        return fids
                .entrySet()
                .stream()
                .filter((entry -> entry.getValue().getSymbolicName().getTitle().isEmpty()))
                .map((entry -> entry.getKey()))
                .collect(Collectors.toList());
    }

    public List<String> fids() {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> fids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        return fids
                .entrySet()
                .stream()
                .map((entry -> entry.getKey()))
                .collect(Collectors.toList());
    }

    public Map<String, Folder> folders() {
        JsonParser parser = new JsonParser();
        JsonElement foldersFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        return new Gson().fromJson(foldersFragment, new TypeToken<Map<String, Folder>>(){}.getType());
    }

    public String folderPop3(Symbol symbol) {
        JsonParser parser = new JsonParser();
        JsonElement fidsFragment = parser.parse(respAsString).getAsJsonObject().get("folders");
        Map<String, Fid> lids = new Gson().fromJson(fidsFragment, new TypeToken<Map<String, Fid>>(){}.getType());
        Optional<Map.Entry<String, Fid>> fidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getSymbolicName()
                                .getTitle()
                                .equals(symbol.toString()))
                .findFirst();
        return fidEntry.isPresent() ? fidEntry.get().getValue().getPop3On() : null;
    }
}
