package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

@OperClass(
        description = "Запрос к hound. Счётчики писем для папок",
        apicommand = "",
        apipath = "/folders_counters"
)
public class FoldersCounters extends Oper<FoldersCounters> {

    public static FoldersCounters foldersCounters(Obj params) {
        return api(FoldersCounters.class).setHost(props().houndUri()).params(params);
    }

    public FoldersCounters errorCode(int code) {
        assertThat(JsonPath.read(respAsString, "$.error.code"), equalTo(code));
        return this;
    }

    public int newMessagesCount(String fid) {
        return JsonPath.read(respAsString, "$.folders." + fid + ".new");
    }

    public int messagesCount(String fid) {
        return JsonPath.read(respAsString, "$.folders." + fid + ".cnt");
    }

    public FoldersCounters expectNewMessagesInFolder(int newCount, String fid) {
        Assert.assertThat(newMessagesCount(fid), Matchers.equalTo(newCount));
        return this;
    }

    public FoldersCounters expectMessagesInFolder(int count, String fid) {
        Assert.assertThat(messagesCount(fid), Matchers.equalTo(count));
        return this;
    }

    public FoldersCounters code(Matcher<Integer> matcher) {
        assertThat("Неверное значение поля <code>", getIntFromJson("error.code"), matcher);
        return this;
    }

    public FoldersCounters message(Matcher<String> matcher) {
        assertThat("Неверное значение поля <message>", getStringFromJson("error.message"), matcher);
        return this;
    }

    public FoldersCounters reason(Matcher<String> matcher) {
        assertThat("Неверное значение поля <reason>", getStringFromJson("error.reason"), matcher);
        return this;
    }
}
