package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import org.apache.commons.httpclient.HttpStatus;
import ru.yandex.autotests.innerpochta.beans.Envelope;
import ru.yandex.autotests.innerpochta.beans.yplatform.Folder;
import ru.yandex.autotests.innerpochta.beans.yplatform.Lid;
import ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis;
import ru.yandex.autotests.innerpochta.wmi.core.hound.v2.stickers.ApiStickers;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.LabelsObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesByFolderObj;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.List;
import java.util.Map;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesByLabelObj.empty;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesByFolder.messagesByFolder;

public class Hound {
    public enum LabelSymbol {
        PINNED("pinned_label"),
        PRIORITY_HIGH("important_label"),
        SPAM("spam_label"),
        SYNCED("synced_label"),
        ATTACHED("attached_label");

        public String getName() {
            return this.name;
        }

        LabelSymbol(String name) {
            this.name = name;
        }

        private String name;
    }

    public static String getLidBySymbolTitle(HttpClientManagerRule authClient, LabelSymbol symbol) {
        Map<String, Lid> labels = Labels.labels(LabelsObj.empty()
                .setUid(authClient.account().uid()))
                .get().via(authClient)
                .statusCodeShouldBe(HttpStatus.SC_OK)
                .labels();
        return labels.entrySet().stream()
                .filter(entry ->
                        entry.getValue().getSymbolicName().getTitle().equals(symbol.getName())
                ).map(Map.Entry::getKey)
                .findFirst()
                .orElse("");
    }

    public static String getLidByNameAndType(HttpClientManagerRule authClient, String name, String type) {
        Map<String, Lid> labels = Labels.labels(LabelsObj.empty()
                .setUid(authClient.account().uid()))
                .get().via(authClient)
                .statusCodeShouldBe(HttpStatus.SC_OK)
                .labels();
        return labels.entrySet().stream()
                .filter(entry ->
                        entry.getValue().getName().equals(name) &&
                                entry.getValue().getType().getTitle().equals(type)
                ).map(Map.Entry::getKey)
                .findFirst()
                .orElse("");
    }

    public static List<Envelope> getLastEnvelopesInFolderBy(HttpClientManagerRule authClient, String fid, Integer count) {
        MessagesByFolderObj obj = MessagesByFolderObj
                .empty()
                .setUid(authClient.account().uid())
                .setFid(fid)
                .setFirst("0")
                .setCount(String.valueOf(count));

        return messagesByFolder(obj)
                .get()
                .via(authClient)
                .resp()
                .getEnvelopes();
    }

    public static Map<String, Folder> folders(HttpClientManagerRule authClient) {
        return api(Folders.class)
                .setHost(props().houndUri())
                .params(empty().setUid(authClient.account().uid()))
                .get()
                .via(authClient)
                .folders();
    }

    public static ApiStickers stickers(HttpClientManagerRule user, ApiStickers.TypeParam type) {
        return WmiApis.apiHoundV2(user.account().userTicket()).stickers()
                .withUid(user.account().uid())
                .withType(type);
    }
}
