package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.innerpochta.beans.labels.LabelSymbol;
import ru.yandex.autotests.innerpochta.beans.yplatform.Label;
import ru.yandex.autotests.innerpochta.beans.yplatform.Lid;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import javax.swing.text.html.Option;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 04.10.13
 * Time: 16:25
 */
@OperClass(
        description = "Запрос к yplatform. Метки",
        apicommand = "",
        apipath = "/labels"
)
public class Labels extends Oper<Labels> {

    public static Labels labels(Obj params) {
        return api(Labels.class).setHost(props().houndUri()).params(params);
    }

    public List<String> userLids() {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());

        return lids
                .entrySet()
                .stream()
                .filter((entry -> entry
                        .getValue()
                        .getIsUser()))
                .map((entry -> entry.getKey()))
                .collect(Collectors.toList());
    }

    public Map<String, Lid> labels() {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        return new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
    }

    public Long countByName(String name) {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
        Optional<Map.Entry<String, Lid>> lidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getName()
                                .equals(name))
                .findFirst();
        return lidEntry.isPresent() ? lidEntry.get().getValue().getMessagesCount() : null;
    }

    public Optional<Long> countByLid(String lid) {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
        Optional<Map.Entry<String, Lid>> lidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getKey()
                                .equals(lid))
                .findFirst();
        return lidEntry.isPresent() ? Optional.of(lidEntry.get().getValue().getMessagesCount()) : Optional.empty();
    }

    public String lidBySymbol(LabelSymbol symbol) {
        return lidByTitle(symbol.toString());
    }

    public String nameBySymbol(LabelSymbol symbol) {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
        Optional<Map.Entry<String, Lid>> lidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getName()
                                .equals(symbol.toString()))
                .findFirst();
        return lidEntry.isPresent() ? lidEntry.get().getValue().getName() : null;
    }

    public String lidByTitle(String lidTitle) {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
        Optional<Map.Entry<String, Lid>> lidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getSymbolicName()
                                .getTitle()
                                .equals(lidTitle))
                .findFirst();
        return lidEntry.isPresent() ? lidEntry.get().getKey() : null;
    }

    public String lidByName(String lidName) {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
        Optional<Map.Entry<String, Lid>> lidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry -> entry
                                .getValue()
                                .getName()
                                .equals(lidName))
                .findFirst();
        return lidEntry.isPresent() ? lidEntry.get().getKey() : null;
    }

    public String lidByNameAndType(String lidName, String typeName) {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");
        Map<String, Lid> lids = new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
        Optional<Map.Entry<String, Lid>> lidEntry = lids
                .entrySet()
                .stream()
                .filter
                        (entry ->
                                entry.getValue().getName().equals(lidName) &&
                                entry.getValue().getType().getTitle().equals(typeName)
                        )
                .findFirst();
        return lidEntry.isPresent() ? lidEntry.get().getKey() : null;
    }
}