package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 03.08.15
 * Time: 19:04
 */
@OperClass(
        description = "Запрос к yplatform. Возвращаем информацию о ревизии почтового ящика.",
        apicommand = "",
        apipath = "/mailbox_revision"
)
public class MailboxRevision extends Oper<MailboxRevision> {

    public static MailboxRevision mailboxRevision(Obj params) {
        return api(MailboxRevision.class).setHost(props().houndUri()).params(params);
    }

    public Integer getRevision() {
        return JsonPath.read(respAsString, "$.mailbox_revision");
    }

    public MailboxRevision revision(Matcher<Integer> revision) {
        assertThat("Неверное значение <mailbox_revision> ", getRevision(), revision);
        return this;
    }
}
