package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.innerpochta.beans.ByTimestampResp;
import ru.yandex.autotests.innerpochta.beans.yplatform.Envelope;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;
import java.util.function.Predicate;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;
import static java.util.stream.Collectors.toList;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 16:43
 */
@OperClass(
        description = "Запрос к yplatform. Выборка писем в заданной папке",
        apicommand = "",
        apipath = "/messages_by_folder"
)
public class MessagesByFolder extends Oper<MessagesByFolder> {
    public ByTimestampResp resp() {
        return fromJson(ByTimestampResp.class);
    }

    public static MessagesByFolder messagesByFolder(Obj params) {
            return api(MessagesByFolder.class).setHost(props().houndUri()).params(params);
    }

    public String firstMidBySubject(String subj) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());
        return envelope
                .stream()
                .filter
                        (e -> e
                                .getSubjectInfo()
                                .getSubject()
                                .equals(subj))
                .map(Envelope::getMid)
                .findFirst()
                .orElse(null);
    }

    public List<String> mids() {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());
        return envelope
                .stream()
                .map(Envelope::getMid)
                .collect(toList());
    }

    public String firstMidIf(Predicate<Envelope> predicate) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());
        return envelope
                .stream()
                .filter(predicate)
                .map(Envelope::getMid)
                .findFirst()
                .orElse(null);
    }

    public List<String> midsBySubject(String subj) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());
        return envelope
                .stream()
                .filter
                        (e -> e
                                .getSubjectInfo()
                                .getSubject()
                                .equals(subj))
                .map(Envelope::getMid)
                .collect(toList());
    }

    public Long receivedDate(String mid) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());

        return envelope
                .stream()
                .filter(
                        (e -> e
                                .getMid()
                                .equals(mid))
                )
                .map(Envelope::getReceiveDate)
                .findFirst()
                .orElse(null);
    }

    public Integer countIf(Predicate<Envelope> predicate) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());

        if (envelope.isEmpty()) {
            return null;
        }

        return (int)envelope
                .stream()
                .filter(predicate)
                .count();
    }
}
