package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.beans.ByTimestampResp;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;

@OperClass(
        description = "Запрос к yplatform. Выборка писем в заданной папке без лида",
        apicommand = "",
        apipath = "/messages_by_folder_and_tab"
)
public class MessagesByFolderAndTab extends Oper<MessagesByFolderAndTab> {
    public ByTimestampResp resp() {
        return fromJson(ByTimestampResp.class);
    }

    public MessagesByFolderAndTab code(Matcher<Integer> matcher) {
        assertThat("Неверное значение поля <code>", getIntFromJson("error.code"), matcher);
        return this;
    }

    public MessagesByFolderAndTab message(Matcher<String> matcher) {
        assertThat("Неверное значение поля <message>", getStringFromJson("error.message"), matcher);
        return this;
    }

    public MessagesByFolderAndTab reason(Matcher<String> matcher) {
        assertThat("Неверное значение поля <reason>", getStringFromJson("error.reason"), matcher);
        return this;
    }
}
