package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.innerpochta.beans.ByTimestampResp;
import ru.yandex.autotests.innerpochta.beans.yplatform.Envelope;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;
import java.util.Optional;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 16:44
 */
@OperClass(
        description = "Запрос к yplatform. Выборка всех непрочитанных писем пользователя",
        apicommand = "",
        apipath = "/messages_unread"
)
public class MessagesUnread extends Oper<MessagesUnread> {
    public ByTimestampResp resp() {
        return fromJson(ByTimestampResp.class);
    }

    public static MessagesUnread messagesUnread(Obj params) {
        return api(MessagesUnread.class).setHost(props().houndUri()).params(params);
    }

    public boolean hasMessage(String mid) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());

        Optional<Envelope> entry = envelope
                .stream()
                .filter
                        (e -> e
                                .getMid()
                                .equals(mid)
                        )
                .findFirst();

        return entry.isPresent();
    }
}
