package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.innerpochta.beans.ByTimestampResp;
import ru.yandex.autotests.innerpochta.beans.yplatform.Envelope;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;
import java.util.Optional;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 16:44
 */
@OperClass(
        description = "Запрос к yplatform. Выборка непрочитанных писем в заданной папке",
        apicommand = "",
        apipath = "/messages_unread_by_folder"
)
public class MessagesUnreadByFolder extends Oper<MessagesUnreadByFolder> {
    public ByTimestampResp resp() {
        return fromJson(ByTimestampResp.class);
    }

    public static MessagesUnreadByFolder messagesUnreadByFolder(Obj params) {
        return api(MessagesUnreadByFolder.class).setHost(props().houndUri()).params(params);
    }

    public boolean hasMessage(String mid, String fid) {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());

        Optional<Envelope> entry = envelope
                .stream()
                .filter
                        (e -> e
                                .getMid()
                                .equals(mid)
                        )
                .filter(
                        e -> e
                                .getFid()
                                .equals(fid)
                        )
                .findFirst();

        return entry.isPresent();
    }

    public int messageCount() {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());
        return envelope.size();
    }
}
